package com.ejie.aa17a.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aEstacionDao;
import com.ejie.aa17a.model.Aa17aEstacion;
import com.ejie.aa17a.utilidades.Aa17aConstantes;

/**
 * Aa17aEstacionDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aEstacionDaoImpl implements Aa17aEstacionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aa17aEstacion> rwMap = new RowMapper<Aa17aEstacion>() {
		public Aa17aEstacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Aa17aEstacion estacion = new Aa17aEstacion();

			estacion.setIdEstacion(resultSet.getLong("IDESTACION"));
			estacion.setCodigoEstacion(resultSet.getString("CODIGOESTACION"));
			estacion.setNombreEstacion(resultSet.getString("NOMBREESTACION"));
			estacion.setDescripcionEstacion(resultSet
					.getString("DESCRIPCIONESTACION"));
			estacion.setDireccionEstacion(resultSet
					.getString("DIRECCIONESTACION"));

			estacion.setIdProvincia(resultSet.getString("IDPROVINCIA"));
			estacion.setIdMunicipio(resultSet.getString("IDMUNICIPIO"));
			estacion.setCoordenadaX(resultSet.getBigDecimal("COORDENADAX"));
			estacion.setCoordenadaY(resultSet.getBigDecimal("COORDENADAY"));

			estacion.setNombreProvincia(resultSet.getString("NOMPROVINCIA"));
			estacion.setNombreMunicipio(resultSet.getString("NOMMUNICIPIO"));

			if (resultSet.getTimestamp("FECHABAJA") != null) {
				estacion.setFechaBaja(new Date(resultSet.getTimestamp(
						"FECHABAJA").getTime()));
			}

			if (estacion.getFechaBaja() != null) {
				estacion.setEstado(Aa17aConstantes.ESTADO_INACTIVO);
			}
			else {
				estacion.setEstado(Aa17aConstantes.ESTADO_ACTIVO);
			}

			estacion.setCoordenadaLat(resultSet.getBigDecimal("COORDENADALAT"));
			estacion.setCoordenadaLon(resultSet.getBigDecimal("COORDENADALON"));

			return estacion;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the Aa17aEstacion table.
	 * 
	 * @param aa17aestacion
	 *            Pagination
	 * @return Aa17aEstacion
	 */
	@Transactional(readOnly = true)
	public Aa17aEstacion find(Aa17aEstacion aa17aestacion) {
		StringBuilder query = new StringBuilder();
		//String query = "SELECT t1.T01_ESTACION_ID IDESTACION, t1.T01_COD_ESTACION CODIGOESTACION, t1.T01_NOMBRE NOMBREESTACION, t1.T01_DESCRIPCION DESCRIPCIONESTACION, t1.T01_DIRECCION DIRECCIONESTACION, t1.T01_PROVINCIA_ID IDPROVINCIA, t1.T01_MUNICIPIO_ID IDMUNICIPIO, t1.T01_COORD_X COORDENADAX, t1.T01_COORD_Y COORDENADAY, t1.T01_FECHA_BAJA FECHABAJA, NULL NOMPROVINCIA, NULL NOMMUNICIPIO FROM AA1701S00 t1  WHERE t1.T01_ESTACION_ID = ? ";
		query.append("SELECT  t1.T01_ESTACION_ID IDESTACION,t1.T01_COD_ESTACION CODIGOESTACION, ");
		query.append(" t1.T01_NOMBRE NOMBREESTACION,t1.T01_DESCRIPCION DESCRIPCIONESTACION,t1.T01_DIRECCION DIRECCIONESTACION,");
		query.append(" t1.T01_PROVINCIA_ID IDPROVINCIA,t1.T01_MUNICIPIO_ID IDMUNICIPIO,");
		query.append(" t1.T01_COORD_X COORDENADAX,t1.T01_COORD_Y COORDENADAY,t1.T01_FECHA_BAJA FECHABAJA, ");

		query.append(" T17I.T17_PROVINCIA.DS_O NOMPROVINCIA, ");
		query.append(" T17I.T17_MUNICIPIO.DS_O NOMMUNICIPIO, ");
		query.append(" t1.T01_COORD_LAT COORDENADALAT, t1.T01_COORD_LON COORDENADALON ");

		query.append(" FROM AA1701S00 t1 ");

		query.append(" INNER JOIN T17I.T17_PROVINCIA ON T17I.T17_PROVINCIA.ID = t1.T01_PROVINCIA_ID ");
		query.append(" INNER JOIN T17I.T17_MUNICIPIO ON T17I.T17_MUNICIPIO.PROVINCIA_ID = T17I.T17_PROVINCIA.ID ");
		query.append(" 								AND T17I.T17_MUNICIPIO.ID = t1.T01_MUNICIPIO_ID ");

		query.append(" WHERE t1.T01_ESTACION_ID = ? ");

		return (Aa17aEstacion) DataAccessUtils.uniqueResult(this.jdbcTemplate.query(query.toString(), this.rwMap, aa17aestacion.getIdEstacion()));
	}

	/**
	 * Finds a List of rows in the Aa17aEstacion table.
	 * 
	 * @param aa17aestacion
	 *            Aa17aEstacion
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aEstacion> findAll(Aa17aEstacion aa17aestacion) {
		StringBuilder query = new StringBuilder();
		query.append("SELECT  t1.T01_ESTACION_ID IDESTACION,t1.T01_COD_ESTACION CODIGOESTACION, ");
		query.append(" t1.T01_NOMBRE NOMBREESTACION,t1.T01_DESCRIPCION DESCRIPCIONESTACION,t1.T01_DIRECCION DIRECCIONESTACION,");
		query.append(" t1.T01_PROVINCIA_ID IDPROVINCIA,t1.T01_MUNICIPIO_ID IDMUNICIPIO,");
		query.append(" t1.T01_COORD_X COORDENADAX,t1.T01_COORD_Y COORDENADAY,t1.T01_FECHA_BAJA FECHABAJA, ");

		query.append(" T17I.T17_PROVINCIA.DS_O NOMPROVINCIA, ");
		query.append(" T17I.T17_MUNICIPIO.DS_O NOMMUNICIPIO, ");
		query.append(" t1.T01_COORD_LAT COORDENADALAT, t1.T01_COORD_LON COORDENADALON ");

		query.append(" FROM AA1701S00 t1 ");

		query.append(" INNER JOIN T17I.T17_PROVINCIA ON T17I.T17_PROVINCIA.ID = t1.T01_PROVINCIA_ID ");
		query.append(" INNER JOIN T17I.T17_MUNICIPIO ON T17I.T17_MUNICIPIO.PROVINCIA_ID = T17I.T17_PROVINCIA.ID ");
		query.append(" 								AND T17I.T17_MUNICIPIO.ID = t1.T01_MUNICIPIO_ID ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17aestacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Aa17aEstacion>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aEstacion entity
	 * 
	 * @param aa17aestacion
	 *            Aa17aEstacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa17aEstacion aa17aestacion) {

		StringBuffer where = new StringBuffer(
				Aa17aEstacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17aestacion != null && aa17aestacion.getIdEstacion() != null) {
			where.append(" AND t1.T01_ESTACION_ID = ?");
			params.add(aa17aestacion.getIdEstacion());
		}
		if (aa17aestacion != null && aa17aestacion.getCodigoEstacion() != null) {
			where.append(" AND t1.T01_COD_ESTACION = ?");
			params.add(aa17aestacion.getCodigoEstacion());
		}
		if (aa17aestacion != null && aa17aestacion.getNombreEstacion() != null
				&& !"".equals(aa17aestacion.getNombreEstacion())) {
			where.append(" AND UPPER(t1.T01_NOMBRE) like ?");
			params.add("%" + aa17aestacion.getNombreEstacion().toUpperCase()
					+ "%");
		}
		if (aa17aestacion != null
				&& aa17aestacion.getDescripcionEstacion() != null) {
			where.append(" AND t1.T01_DESCRIPCION = ?");
			params.add(aa17aestacion.getDescripcionEstacion());
		}
		if (aa17aestacion != null
				&& aa17aestacion.getDireccionEstacion() != null) {
			where.append(" AND t1.T01_DIRECCION = ?");
			params.add(aa17aestacion.getDireccionEstacion());
		}
		if (aa17aestacion != null && aa17aestacion.getIdProvincia() != null
				&& !"".equals(aa17aestacion.getIdProvincia())) {
			where.append(" AND t1.T01_PROVINCIA_ID = ?");
			params.add(aa17aestacion.getIdProvincia());
		}
		if (aa17aestacion != null && aa17aestacion.getIdMunicipio() != null
				&& !"".equals(aa17aestacion.getIdMunicipio())) {
			where.append(" AND t1.T01_MUNICIPIO_ID = ?");
			params.add(aa17aestacion.getIdMunicipio());
		}
		if (aa17aestacion != null && aa17aestacion.getCoordenadaX() != null) {
			where.append(" AND t1.T01_COORD_X = ?");
			params.add(aa17aestacion.getCoordenadaX());
		}
		if (aa17aestacion != null && aa17aestacion.getCoordenadaY() != null) {
			where.append(" AND t1.T01_COORD_Y = ?");
			params.add(aa17aestacion.getCoordenadaY());
		}
		if (aa17aestacion != null && aa17aestacion.getFechaBaja() != null) {
			where.append(" AND t1.T01_FECHA_BAJA = ?");
			params.add(aa17aestacion.getFechaBaja());
		}

		if (aa17aestacion != null && aa17aestacion.getEstado() != null & aa17aestacion.getEstado() == Aa17aConstantes.ESTADO_ACTIVO) {
			where.append(" AND t1.T01_FECHA_BAJA IS NULL ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
